
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(400*x1 + 1500*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 350)
    model.addConstr(750*x1 + 3000*x2 <= 500000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of student version software packages: {x1.varValue}")
        print(f"Number of professional version software packages: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
