
import gurobipy as gp

# Create a new model
model = gp.Model("CarProduction")

# Create variables
electric_cars = model.addVar(vtype=gp.GRB.INTEGER, name="electric_cars")
gas_cars = model.addVar(vtype=gp.GRB.INTEGER, name="gas_cars")


# Set objective function
model.setObjective(5000 * electric_cars + 3000 * gas_cars, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(electric_cars <= 3, "electric_car_production_limit")
model.addConstr(gas_cars <= 5, "gas_car_production_limit")
model.addConstr(electric_cars + gas_cars <= 5, "finishing_factory_capacity")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of electric cars to produce: {electric_cars.x}")
    print(f"Number of gas cars to produce: {gas_cars.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

