
from gurobipy import *

# Create a model
m = Model("Car Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="electric_cars")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="gas_cars")

# Set the objective function
m.setObjective(5000*x1 + 3000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 3, "electric_car_factory")
m.addConstr(x2 <= 5, "gas_car_factory")
m.addConstr(x1 + x2 <= 5, "finishing_touched_factory")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Electric cars: {x1.x}")
    print(f"Gas cars: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
