
import gurobipy as gp

# Create a new model
model = gp.Model("Electric_and_Gas_Cars_Production")

# Define variables
x1 = model.addVar(lb=0, ub=3, vtype=gp.GRB.INTEGER, name="electric_cars")
x2 = model.addVar(lb=0, ub=5, vtype=gp.GRB.INTEGER, name="gas_cars")

# Objective function: Maximize 5000*x1 + 3000*x2
model.setObjective(5000*x1 + 3000*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 5, name="total_cars_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production levels: Electric cars = {x1.varValue}, Gas cars = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("The model is infeasible or unbounded.")
