
import gurobipy as gp

# Create a new model
m = gp.Model("chandelier_production")

# Create variables
glass = m.addVar(vtype=gp.GRB.CONTINUOUS, name="glass")  # Number of glass chandeliers
brass = m.addVar(vtype=gp.GRB.CONTINUOUS, name="brass")  # Number of brass chandeliers


# Set objective function
m.setObjective(400 * glass + 300 * brass, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * glass + 1.5 * brass <= 750, "crafting_time")
m.addConstr(1 * glass + 0.75 * brass <= 500, "installation_time")
m.addConstr(glass >= 0, "glass_nonnegative")  # Ensure non-negative production
m.addConstr(brass >= 0, "brass_nonnegative")  # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of glass chandeliers: {glass.x}")
    print(f"Number of brass chandeliers: {brass.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

