
from gurobipy import *

# Create a new model
m = Model("Chandelier_Production")

# Define variables
x1 = m.addVar(lb=0, name="glass_chandeliers")
x2 = m.addVar(lb=0, name="brass_chandeliers")

# Set the objective function
m.setObjective(400*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 1.5*x2 <= 750, name="crafting_time")
m.addConstr(x1 + 0.75*x2 <= 500, name="installation_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
