
import gurobi

def solve_chandelier_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="glass_chandeliers", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="brass_chandeliers", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(400 * x1 + 300 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 1.5 * x2 <= 750, name="crafting_hours")
    model.addConstr(x1 + 0.75 * x2 <= 500, name="installation_hours")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_chandelier_problem()
