
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
trust_investment = m.addVar(name="trust_investment")
savings_investment = m.addVar(name="savings_investment")

# Set objective function
m.setObjective(0.02 * trust_investment + 0.03 * savings_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(trust_investment + savings_investment <= 60000, "total_investment")
m.addConstr(trust_investment >= 0.15 * 60000, "min_trust_investment")
m.addConstr(savings_investment <= 0.80 * 60000, "max_savings_investment")
m.addConstr(trust_investment >= 0, "non_negative_trust")
m.addConstr(savings_investment >= 0, "non_negative_savings")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal investment strategy:")
    print(f"Trust Investment: ${trust_investment.x}")
    print(f"Savings Investment: ${savings_investment.x}")
    print(f"Total Return: ${m.objVal}")

