
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Add variables to the model
x1 = m.addVar(lb=0, name="trust")
x2 = m.addVar(lb=0, name="savings")

# Set the objective function
m.setObjective(0.02*x1 + 0.03*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(x1 + x2 <= 60000, "total_investment")
m.addConstr(x1 >= 0.15*60000, "min_trust")
m.addConstr(x2 <= 0.8*60000, "max_savings")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in trust: {x1.x}")
    print(f"Amount invested in savings account: {x2.x}")
    print(f"Maximum return on investment: {m.objVal}")
else:
    print("No optimal solution found")
