
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='trust_investment', lb=0)
    x2 = model.addVar(name='savings_investment', lb=0)

    # Objective function: maximize 0.02*x1 + 0.03*x2
    model.setObjective(0.02 * x1 + 0.03 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 == 60000, name='total_investment')
    model.addConstr(x1 >= 0.15 * 60000, name='min_trust_investment')
    model.addConstr(x2 <= 0.80 * 60000, name='max_savings_investment')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in trust: ${x1.varValue:.2f}")
        print(f"Optimal investment in savings: ${x2.varValue:.2f}")
        print(f"Max return: ${0.02*x1.varValue + 0.03*x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
