
import gurobipy as gp

# Create a new model
m = gp.Model("BakeryOptimization")

# Create variables
pies = m.addVar(lb=0, name="pies")  # Number of pies
tarts = m.addVar(lb=0, name="tarts") # Number of tarts


# Set objective function
m.setObjective(8 * pies + 5 * tarts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * pies + 3 * tarts <= 1000, "BlueberryConstraint")
m.addConstr(tarts >= 3 * pies, "TartPieRatioConstraint")
m.addConstr(pies >= 30, "MinPieConstraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pies: {pies.x}")
    print(f"Number of tarts: {tarts.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

