
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="pies")
x2 = m.addVar(vtype=GRB.INTEGER, name="tarts")

# Set the objective function: maximize profit
m.setObjective(8*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 1000, "blueberries_limit")
m.addConstr(x2 >= 3*x1, "tarts_to_pies_ratio")
m.addConstr(x1 >= 30, "minimum_pies")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
