
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=30, name="pies")  # At least 30 pies
    x2 = model.addVar(name="tarts")

    # Objective function: Maximize 8x1 + 5x2
    model.setObjective(8 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x1 + 3 * x2 <= 1000, name="blueberry_limit")
    model.addConstr(x2 >= 3 * x1, name="tarts_to_pies_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Pies = {x1.varValue}, Tarts = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_bakery_problem()
