
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_production")

# Create variables
hoodies = m.addVar(vtype=GRB.CONTINUOUS, name="hoodies")
sweaters = m.addVar(vtype=GRB.CONTINUOUS, name="sweaters")


# Set objective function
m.setObjective(20 * hoodies + 15 * sweaters, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * hoodies + 2 * sweaters <= 500, "fabric_constraint")
m.addConstr(2 * hoodies + 1.5 * sweaters <= 300, "dye_constraint")
m.addConstr(hoodies >= 0, "hoodies_nonnegative")
m.addConstr(sweaters >= 0, "sweaters_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of hoodies to produce: {hoodies.x:.2f}")
    print(f"Number of sweaters to produce: {sweaters.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

