
from gurobipy import *

# Create a new model
m = Model("Hoodies_and_Sweaters")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hoodies")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="sweaters")

# Set the objective function
m.setObjective(20*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 500, "fabric")
m.addConstr(2*x1 + 1.5*x2 <= 300, "dye")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of hoodies: {x1.x}")
    print(f"Number of sweaters: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
