
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="x1")  # Number of hoodies
    x2 = model.addVar(lb=0, name="x2")  # Number of sweaters

    # Define the objective function
    model.setObjective(20 * x1 + 15 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 2 * x2 <= 500, name="fabric_constraint")
    model.addConstr(2 * x1 + 1.5 * x2 <= 300, name="dye_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of hoodies: {x1.varValue}")
        print(f"Number of sweaters: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
