
import gurobipy as gp

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="individual_salads") # Number of individual salads
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="family_salads")    # Number of family salads

# Set objective function
m.setObjective(4*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 18*x2 <= 220, "lettuce_constraint")
m.addConstr(2*x1 + 6*x2 <= 150, "tomato_constraint")
m.addConstr(2*x1 + 5*x2 <= 140, "sauce_constraint")
m.addConstr(x1 >= 0, "non_negativity_x1")  # Ensure non-negative number of salads
m.addConstr(x2 >= 0, "non_negativity_x2")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of individual salads: {x1.x}")
    print(f"Number of family salads: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

