
from gurobipy import *

# Create a new model
model = Model("Salad_Sales")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="individual_salads")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="family_sized_salads")

# Set the objective function
model.setObjective(4*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 18*x2 <= 220, "lettuce_constraint")
model.addConstr(2*x1 + 6*x2 <= 150, "tomatoes_constraint")
model.addConstr(2*x1 + 5*x2 <= 140, "sauce_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Individual salads: {x1.x}")
    print(f"Family-sized salads: {x2.x}")
    print(f"Total profit: ${4*x1.x + 7*x2.x:.2f}")
else:
    print("No optimal solution found.")
