
import gurobi

def solve_salad_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="individual_salad", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="family_sized_salad", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: maximize 4*x1 + 7*x2
    model.setObjective(4*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 18*x2 <= 220, name="lettuce_constraint")
    model.addConstr(2*x1 + 6*x2 <= 150, name="tomatoes_constraint")
    model.addConstr(2*x1 + 5*x2 <= 140, name="sauce_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Individual salads: {x1.varValue}")
        print(f"Family-sized salads: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_salad_problem()
