
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Miles_Investment")

# Create variables
floral = m.addVar(nonnegative=True, name="floral")
healthcare = m.addVar(nonnegative=True, name="healthcare")

# Set objective function
m.setObjective(1.3 * floral + 1.5 * healthcare, GRB.MAXIMIZE)

# Add constraints
m.addConstr(floral + healthcare <= 10000, "Total_Investment")
m.addConstr(floral >= 0.25 * (floral + healthcare), "Floral_Percentage")
m.addConstr(healthcare >= 2000, "Healthcare_Minimum")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Investment Strategy:")
    print(f"Floral Industry: ${floral.x:.2f}")
    print(f"Healthcare Industry: ${healthcare.x:.2f}")
    print(f"Total Profit: ${m.objVal:.2f}")

