
from gurobipy import *

# Create a new model
m = Model("Miles_Investment")

# Define variables
x1 = m.addVar(lb=0, name="Floral_Industry")
x2 = m.addVar(lb=0, name="Healthcare_Industry")

# Objective function: Maximize profit
m.setObjective(1.3*x1 + 1.5*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 10000, "Total_Investment")
m.addConstr(x1 >= 0.25*(x1 + x2), "Floral_Industry_Minimum")
m.addConstr(x2 >= 2000, "Healthcare_Industry_Minimum")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in Floral Industry: {x1.x}")
    print(f"Amount invested in Healthcare Industry: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
