
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="floral_investment", lb=0)
    x2 = model.addVar(name="healthcare_investment", lb=0)

    # Objective function: Maximize 1.3*x1 + 1.5*x2
    model.setObjective(1.3 * x1 + 1.5 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 10000, name="total_investment")
    model.addConstr(x1 >= 0.25 * (x1 + x2), name="floral_percentage")
    model.addConstr(x2 >= 2000, name="healthcare_minimum")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Floral Industry Investment: ${x1.x:.2f}")
        print(f"Healthcare Industry Investment: ${x2.x:.2f}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
