
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("figurine_production")

# Create variables
superhero = m.addVar(vtype=GRB.CONTINUOUS, name="superhero")
cartoon = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon")


# Set objective function
m.setObjective(10 * superhero + 8 * cartoon, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * superhero + 3 * cartoon <= 1000, "printer_A_constraint")
m.addConstr(4 * superhero + 7 * cartoon <= 1000, "printer_B_constraint")
m.addConstr(superhero >=0)
m.addConstr(cartoon >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of superhero figurines: {superhero.x:.2f}")
    print(f"Number of cartoon figurines: {cartoon.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

