
from gurobipy import *

# Create a new model
m = Model("Jake's_Figurines")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="superhero_figurines", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon_figurines", lb=0)

# Set the objective function
m.setObjective(10*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 1000, "Printer_A_Time")
m.addConstr(4*x1 + 7*x2 <= 1000, "Printer_B_Time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Superhero Figurines: {x1.x}")
    print(f"Cartoon Figurines: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
