
import gurobipy as gp

# Create a new model
model = gp.Model("Figurine Production")

# Define variables
x1 = model.addVar(name="superhero_figurines", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="cartoon_figurines", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(10*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(5*x1 + 3*x2 <= 1000, name="Printer_A_constraint")
model.addConstr(4*x1 + 7*x2 <= 1000, name="Printer_B_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.x[0]} superhero figurines, {model.x[1]} cartoon figurines")
    print(f"Max profit: ${model.objVal}")
else:
    print("No optimal solution found")
