
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cooper's Produce Optimization")

# Create variables
potatoes = m.addVar(lb=0, vtype=GRB.INTEGER, name="potatoes")
pumpkins = m.addVar(lb=0, vtype=GRB.INTEGER, name="pumpkins")


# Set objective function
m.setObjective(1.5 * potatoes + 2.8 * pumpkins, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5 * potatoes + 0.9 * pumpkins <= 1000, "Budget")
m.addConstr(pumpkins <= (1/3) * potatoes, "Pumpkin Limit")
m.addConstr(potatoes >= 250, "Min Potatoes")
m.addConstr(potatoes <= 800, "Max Potatoes")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Potatoes to Sell: {potatoes.x}")
    print(f"Number of Pumpkins to Sell: {pumpkins.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

