
from gurobipy import *

# Create a new model
m = Model("Cooper_Problem")

# Define variables
x1 = m.addVar(lb=250, ub=800, vtype=GRB.INTEGER, name="potatoes")
x2 = m.addVar(vtype=GRB.INTEGER, name="pumpkins")

# Objective function: Maximize profit
m.setObjective(1.5*x1 + 2.8*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(0.50*x1 + 0.90*x2 <= 1000, "cost_constraint")
m.addConstr(x2 <= (1/3)*x1, "pumpkin_sales_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
else:
    print("No optimal solution found")
