
import gurobipy as gp

# Create a new model
m = gp.Model("Cooper_Store_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="potatoes")  # Number of potatoes
x2 = m.addVar(lb=0, name="pumpkins")  # Number of pumpkins

# Objective function: Maximize profit
m.setObjective(1.5*x1 + 2.8*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.50*x1 + 0.90*x2 <= 1000, name="cost_constraint")
m.addConstr(-x1 + 3*x2 <= 0, name="pumpkin_potato_ratio")
m.addConstr(x1 >= 250, name="min_potatoes")
m.addConstr(x1 <= 800, name="max_potatoes")

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of potatoes: {x1.varValue}")
    print(f"Number of pumpkins: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("The model is infeasible.")
