
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("croissant_optimization")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="chocolate_croissants") # Number of chocolate croissants
x2 = m.addVar(vtype=GRB.INTEGER, name="strawberry_croissants") # Number of strawberry croissants


# Set objective function: Maximize profit
m.setObjective(4*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 6000, "cost_constraint") # Cost constraint
m.addConstr(x1 + x2 <= 1200, "demand_constraint") # Demand constraint
m.addConstr(x1 >= 0, "non_negativity_x1") # Non-negativity constraint
m.addConstr(x2 >= 0, "non_negativity_x2") # Non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of chocolate croissants: {x1.x}")
    print(f"Number of strawberry croissants: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

