
from gurobipy import *

# Create a new model
model = Model("Croissant_Optimization")

# Add variables to the model
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_croissants")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberry_croissants")

# Set the objective function
model.setObjective(4*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 1200, "total_croissants")
model.addConstr(3*x1 + 5*x2 <= 6000, "budget")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Croissants: {x1.x}")
    print(f"Strawberry Croissants: {x2.x}")
    print(f"Total Profit: {model.ObjVal}")
else:
    print("No optimal solution found")
