
import gurobipy as gp

# Create a new model
model = gp.Model("Croissant_Optimization")

# Define the variables
x1 = model.addVar(name="chocolate_croissants", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="strawberry_croissants", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(4*x1 + 6*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 1200, name="total_croissants")
model.addConstr(3*x1 + 5*x2 <= 6000, name="total_cost")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: chocolate croissants = {x1.varValue}, strawberry croissants = {x2.varValue}")
else:
    print("No optimal solution found")
