
from gurobipy import Model, GRB

# Create a new model
m = Model("Travel_Company_Optimization")

# Create variables
guided_tours = m.addVar(vtype=GRB.INTEGER, name="guided_tours")
regular_tickets = m.addVar(vtype=GRB.INTEGER, name="regular_tickets")

# Set objective function
m.setObjective(500 * guided_tours + 200 * regular_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(guided_tours + regular_tickets <= 300, "Total_Tickets")
m.addConstr(guided_tours >= 50, "Min_Guided_Tours")
m.addConstr(regular_tickets >= 2 * guided_tours, "Regular_vs_Guided")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Guided Tour Packages: {guided_tours.x}")
    print(f"Number of Regular Tickets: {regular_tickets.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

