
from gurobipy import *

# Create a new model
m = Model("Travel_Company_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="guided_tour_packages")
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_tickets")

# Set the objective function
m.setObjective(500*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, "total_tickets")
m.addConstr(x1 >= 50, "min_guided_tours")
m.addConstr(x2 >= 2*x1, "regular_vs_guided")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Guided tour packages: {x1.x}")
    print(f"Regular tickets: {x2.x}")
    print(f"Total profit: ${500*x1.x + 200*x2.x}")
else:
    print("No optimal solution found")
