
import gurobi

def solve_travel_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="guided_tour_packages")
    x2 = model.addVar(lb=0, name="regular_tickets")

    # Objective function: Maximize 500*x1 + 200*x2
    model.setObjective(500*x1 + 200*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300, name="total_tickets")
    model.addConstr(x1 >= 50, name="min_guided_tour_packages")
    model.addConstr(x2 >= 2*x1, name="regular_tickets_vs_guided_tour_packages")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Guided tour packages: {x1.varValue}")
        print(f"Regular tickets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_travel_company_problem()
