
import gurobipy as gp

# Create a new model
model = gp.Model("tea_shop_optimization")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="package_X")  # Number of package X
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="package_Y")  # Number of package Y


# Set objective function: Maximize profit
model.setObjective(70 * x1 + 120 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x1 + 3 * x2 <= 1200, "green_tea_constraint")
model.addConstr(2 * x1 + 4 * x2 <= 900, "black_tea_constraint")
model.addConstr(x1 >= 0, "x1_nonnegativity")
model.addConstr(x2 >= 0, "x2_nonnegativity")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${model.objVal:.2f}")
    print(f"Number of Package X: {x1.x:.2f}")
    print(f"Number of Package Y: {x2.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

