
from gurobipy import *

# Create a new model
m = Model("Tea_Shop_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Packages_X")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Packages_Y")

# Set the objective function
m.setObjective(70*x1 + 120*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 1200, "Green_Tea_Constraint")
m.addConstr(2*x1 + 4*x2 <= 900, "Black_Tea_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Packages X: {x1.x}")
    print(f"Number of Packages Y: {x2.x}")
    print(f"Maximum Profit: ${70*x1.x + 120*x2.x:.2f}")
else:
    print("No optimal solution found")
