
import gurobi

def solve_tea_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="packages_X")
    x2 = model.addVar(lb=0, name="packages_Y")

    # Define the objective function
    model.setObjective(70*x1 + 120*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*x1 + 3*x2 <= 1200, name="green_tea_constraint")
    model.addConstr(2*x1 + 4*x2 <= 900, name="black_tea_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Packages X: {x1.varValue}")
        print(f"Packages Y: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_tea_shop_problem()
