
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle Production")

# Create variables
suv = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="SUV")  # Number of SUVs produced
minivan = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="Minivan") # Number of minivans produced


# Set objective function
model.setObjective(7500 * suv + 4000 * minivan, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(suv <= 5, "SUV_Factory_Capacity")
model.addConstr(minivan <= 3, "Minivan_Factory_Capacity")
model.addConstr(suv + minivan <= 5, "Finishing_Capacity")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of SUVs to produce: {suv.x}")
    print(f"Number of Minivans to produce: {minivan.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

