
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SUV_Cars")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Minivans")

# Set the objective function
m.setObjective(7500*x1 + 4000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 5, "SUV_Factory_Capacity")
m.addConstr(x2 <= 3, "Minivan_Factory_Capacity")
m.addConstr(x1 + x2 <= 5, "Third_Party_Processing_Capacity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"SUV Cars: {x1.x}")
    print(f"Minivans: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
