
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=5, name="SUV_cars")
    x2 = model.addVar(lb=0, ub=3, name="minivans")

    # Define the objective function
    model.setObjective(7500 * x1 + 4000 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 5, name="SUV_factory_constraint")
    model.addConstr(x2 <= 3, name="minivan_factory_constraint")
    model.addConstr(x1 + x2 <= 5, name="finishing_touches_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of SUV cars to produce: {x1.varValue}")
        print(f"Number of minivans to produce: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
