
import gurobipy as gp

# Create a new model
m = gp.Model("snow_removal")

# Create variables
x1 = m.addVar(lb=0, name="northern_city_snow")  # Kilograms of snow removed from northern city
x2 = m.addVar(lb=0, name="southern_city_snow")  # Kilograms of snow removed from southern city

# Set objective function
m.setObjective(2 * x1 + 1.5 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x1 + x2 <= 500, "snow_plow_constraint")
m.addConstr(x1 + 3 * x2 <= 500, "truck_constraint")
m.addConstr(5 * x1 + 2 * x2 <= 500, "shovel_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Kilograms of snow removed from northern city: {x1.x:.2f}")
    print(f"Kilograms of snow removed from southern city: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

