
import gurobipy as gp

# Create a new model
model = gp.Model("Snow Removal")

# Define the variables
x1 = model.addVar(name="x1", lb=0, ub=gp.GRB.INFINITY)  # kilograms of snow removed in the northern city
x2 = model.addVar(name="x2", lb=0, ub=gp.GRB.INFINITY)  # kilograms of snow removed in the southern city

# Define the objective function
model.setObjective(2 * x1 + 1.5 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(2 * x1 + 1 * x2 <= 500, name="snow_plow_constraint")
model.addConstr(1 * x1 + 3 * x2 <= 500, name="truck_constraint")
model.addConstr(5 * x1 + 2 * x2 <= 500, name="shovel_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Kilograms of snow removed in the northern city: {x1.varValue}")
    print(f"Kilograms of snow removed in the southern city: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
