
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="beans")
cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")

# Set objective function
m.setObjective(2 * beans + 1 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(50 * beans + 30 * cereal >= 300, "carbohydrates")
m.addConstr(20 * beans + 5 * cereal >= 150, "protein")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Beans: {beans.x}")
    print(f"  Cereal: {cereal.x}")
    print(f"  Cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

