
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_beans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_cereal")

# Set the objective function
m.setObjective(2*x1 + x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(50*x1 + 30*x2 >= 300, "carbohydrate_requirement")
m.addConstr(20*x1 + 5*x2 >= 150, "protein_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of beans: {x1.x}")
    print(f"Servings of cereal: {x2.x}")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
