
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # servings of beans
x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # servings of cereal

# Define the objective function
model.setObjective(2*x1 + x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(50*x1 + 30*x2 >= 300, name='carbohydrate_requirement')
model.addConstr(20*x1 + 5*x2 >= 150, name='protein_requirement')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print(f"Optimal servings of beans: {x1.varValue}")
    print(f"Optimal servings of cereal: {x2.varValue}")
    print(f"Minimum cost: {model.objVal}")
else:
    print("The problem is infeasible")
