
import gurobipy as gp

# Create a new model
model = gp.Model("Advertising Optimization")

# Create variables
taxi_ads = model.addVar(vtype=gp.GRB.INTEGER, name="taxi_ads")
bus_ads = model.addVar(vtype=gp.GRB.INTEGER, name="bus_ads")
car_ads = model.addVar(vtype=gp.GRB.INTEGER, name="car_ads")

# Set objective function
model.setObjective(5000 * taxi_ads + 12000 * bus_ads + 2000 * car_ads, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(500 * taxi_ads + 1000 * bus_ads + 300 * car_ads <= 20000, "budget_constraint")
model.addConstr(bus_ads <= 8, "bus_limit")
model.addConstr(taxi_ads <= 0.3 * (taxi_ads + bus_ads + car_ads), "taxi_proportion")
model.addConstr(car_ads >= 0.2 * (taxi_ads + bus_ads + car_ads), "car_proportion")

# Solve the model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Taxi Ads: {taxi_ads.x}")
    print(f"Bus Ads: {bus_ads.x}")
    print(f"Car Ads: {car_ads.x}")
    print(f"Total Viewership: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

