
import gurobipy as gp

def solve_ad_optimization():
    # Create a new model
    model = gp.Model("ad_optimization")

    # Define variables
    x1 = model.addVar(name="taxis", vtype=gp.GRB.INTEGER)  # ads on taxis
    x2 = model.addVar(name="buses", vtype=gp.GRB.INTEGER)  # ads on buses
    x3 = model.addVar(name="privately_owned_cars", vtype=gp.GRB.INTEGER)  # ads on privately owned cars

    # Objective function: Maximize viewership
    model.setObjective(5000*x1 + 12000*x2 + 2000*x3, gp.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(500*x1 + 1000*x2 + 300*x3 <= 20000, name="budget_constraint")

    # Bus company limit
    model.addConstr(x2 <= 8, name="bus_limit")

    # Taxi ads percentage
    model.addConstr(0.7*x1 - 0.3*x2 - 0.3*x3 <= 0, name="taxi_percentage")

    # Privately owned cars ads percentage
    model.addConstr(-0.2*x1 - 0.2*x2 + 0.8*x3 >= 0, name="private_car_percentage")

    # Non-negativity constraints
    model.addConstr(x1 >= 0, name="x1_non_negative")
    model.addConstr(x2 >= 0, name="x2_non_negative")
    model.addConstr(x3 >= 0, name="x3_non_negative")

    # Solve the model
    model.optimize()

    if model.status == gp.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ads on taxis: {x1.varValue}")
        print(f"Ads on buses: {x2.varValue}")
        print(f"Ads on privately owned cars: {x3.varValue}")
        print(f"Max viewership: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_ad_optimization()
