
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # Regular ice cream
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # Premium ice cream


# Set objective function
m.setObjective(1*x1 + 2.5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 40, "demand_regular")
m.addConstr(x2 <= 25, "demand_premium")
m.addConstr(x1 + x2 <= 60, "total_production")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Regular ice cream: {x1.x}")
    print(f"Premium ice cream: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

