
from gurobipy import *

# Create a new model
m = Model("Ice_Cream_Profit")

# Define variables
x1 = m.addVar(lb=0, name="regular_ice_cream")
x2 = m.addVar(lb=0, name="premium_ice_cream")

# Set the objective function
m.setObjective(1*x1 + 2.50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 40, "regular_demand")
m.addConstr(x2 <= 25, "premium_demand")
m.addConstr(x1 + x2 <= 60, "total_production")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular ice creams: {x1.x}")
    print(f"Number of premium ice creams: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
