
import gurobi

def solve_ice_cream_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="regular_ice_cream")
    x2 = model.addVar(lb=0, name="premium_ice_cream")

    # Set the objective function
    model.setObjective(1*x1 + 2.5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 40, name="regular_demand_constraint")
    model.addConstr(x2 <= 25, name="premium_demand_constraint")
    model.addConstr(x1 + x2 <= 60, name="total_production_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Regular ice cream: {x1.varValue}")
        print(f"Premium ice cream: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

# Run the function
solve_ice_cream_problem()
